<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SystemActivityNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Payload data for the notification.
     * Avoid typed properties for PHP < 7.4 compatibility.
     * @var array
     */
    protected $payload = [];

    public function __construct(array $payload)
    {
        $this->payload = $payload;
    }

    public function via($notifiable)
    {
        // In-app database notification; can extend with 'mail' later.
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        // Expected keys in payload: title, body, url, meta
        return [
            'title' => $this->payload['title'] ?? 'Activity',
            'body'  => $this->payload['body'] ?? '',
            'url'   => $this->payload['url'] ?? '',
            'meta'  => $this->payload['meta'] ?? [],
        ];
    }
}
